<?php
/**
 * msattachments Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package msattachments
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_MSATTACHMENTS_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'msattachments-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_MSATTACHMENTS_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

function featured_posts_slider_shortcode() {
    // Query for featured posts
    $args = array(
        'posts_per_page' => 5, // Limit to 5 posts
        'meta_key' => '_is_ns_featured_post',
        'meta_value' => 'yes'
    );
    $featured_posts = new WP_Query($args);

    // Start the slider HTML
    $output = '<div class="slider dfdfdfd">';

    // Loop through the posts
    if ($featured_posts->have_posts()) {
        while ($featured_posts->have_posts()) {
            $featured_posts->the_post();

            // Prepare the variables
            $post_title = get_the_title();
            $post_link = get_permalink();
            $category = get_the_category();
			$category_link = get_category_link($category[0]->term_id);
            $category_name = $category[0]->name ?? 'Uncategorized';
            $description = get_the_excerpt();
            $featured_image = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') ?: 'https://via.placeholder.com/150';

            // Append each post to the output
            $output .= '<div class="slide">';
            $output .= '<a href="' . esc_url($category_link) . '">';
            $output .= '<img src="' . esc_url($featured_image) . '" alt="' . esc_attr($post_title) . '" class="product-image">';
            $output .= '<div class="info">';
            $output .= '<p class="category">' . esc_html($category_name) . '</p>';
            $output .= '<h2 class="title">' . esc_html($post_title) . '</h2>';
            $output .= '<p class="description">' . esc_html($description) . '</p>';
            $output .= '</div>';
            $output .= '<div class="arrow-link">→</div>';
            $output .= '</a></div>';
        }
        wp_reset_postdata();
    } else {
        $output .= '<p>No featured posts available.</p>';
    }

    $output .= '</div>'; // End slider HTML

    // Add Slick initialization script
    $output .= '
    <script>
    jQuery(document).ready(function($){
        $(".slider").slick({
            slidesToShow: 2,   // Show 2 slides on larger screens
            slidesToScroll: 1,
            arrows: true,
            infinite: true,
            responsive: [
                {
                    breakpoint: 767, // When screen width is < 767px
                    settings: {
                        slidesToShow: 1,  // Show 1 slide on mobile
                        slidesToScroll: 1
                    }
                }
            ]
        });
    });
</script>

<style>
    .dfdfdfd {
      width: 100%;
      margin: 20px auto;
    }
    .dfdfdfd .slick-slide {
      padding: 10px;
      display: flex;
      justify-content: center;
      align-items: stretch; /* Ensures the slide stretches to fit content */
      height: 320px; /* Fixed height for uniformity */
      box-sizing: border-box;
    }
    .dfdfdfd a {
      display: flex;
      align-items: center;
      justify-content: space-between;
      width: 100%;
      height: 100%; /* Match height of slide container */
      border: 1px solid #ddd;
      border-radius: 8px;
      background: #fff;
      box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      color: #333;
      text-decoration: none;
      transition: transform 0.3s;
      position: relative;
    }
    .dfdfdfd a:hover {
      transform: scale(1.02);
    }
    .dfdfdfd .product-image {
      flex: 0 0 30%;
     
      object-fit: cover; /* Ensures image covers its space consistently */
      margin: 0 15px;
    }
    .dfdfdfd .info {
      flex-grow: 1;
      padding: 15px;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }
   .dfdfdfd .category, .dfdfdfd .title, .dfdfdfd .description {
      margin: 0;
    }
   .dfdfdfd .category {
      font-size: 0.9em;
      color: #888;
    }
   .dfdfdfd .title {
      margin: 5px 0;
      font-size: 1.2em;
      font-weight: bold;
    }
   .dfdfdfd .description {
      font-size: 0.9em;
      color: #555;
    }
    .dfdfdfd .arrow-link {
      position: absolute;
      top: 10px;
      right: 15px;
      font-size: 1.5em;
      color: #007BFF;
    }
    .dfdfdfd .slick-prev:before, .dfdfdfd .slick-next:before {
      color: #007BFF;
      font-size: 1.5em;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .dfdfdfd .slick-slide {
        height: auto;
      }
      .dfdfdfd a {
        flex-direction: column;
        text-align: center;
      }
      .dfdfdfd .product-image {
        width: 100%;
        height: auto;
        margin: 0 0 10px 0; /* Adjust margin for centered images */
      }
    }
</style>';

    return $output;
}

add_shortcode('featured_posts_slider', 'featured_posts_slider_shortcode');

function enqueue_slick_slider_scripts() {
    // Slick CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css');
    wp_enqueue_style('slick-theme-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css');

    // Slick JS
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js', array('jquery'), '1.8.1', true);
}
add_action('wp_enqueue_scripts', 'enqueue_slick_slider_scripts');

